/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.javad.components.MessagePanel;
import org.javad.components.UIHelper;
import org.javad.pdf.fonts.PdfFontBean;
import org.javad.pdf.fonts.PdfFontMapping;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;
import pub.domain.GradientPanel;

public class PdfFontEditor
extends JDialog {
    private JPanel contentPanel;
    private JPanel buttonPanel;
    private GradientPanel mainPanel;
    private JButton btnOk;
    private JButton btnCancel;
    private JLabel usageLabel;
    private JLabel usageValueLabel;
    private MessagePanel messagePanel;
    private JLabel aliasLabel;
    private JRadioButton systemRadio;
    private JComboBox systemComboBox;
    private JRadioButton userRadio;
    private JComboBox userComboBox;
    private JLabel sizeLabel;
    private JFormattedTextField sizeText;
    private JLabel sizeLabelHelp;
    private JPanel panel;
    private JCheckBox checkboxBold;
    private JCheckBox checkboxItalic;
    private JCheckBox checkboxUnderline;
    private JLabel styleLabel;
    private ButtonGroup buttonGroup;
    private PdfFontBean fontBean;
    private static final Logger logger = Logger.getLogger(PdfFontEditor.class.getName());

    public PdfFontEditor() {
        this.setSize(475, 420);
        this.setModal(true);
        this.setTitle(Resources.getString("title.editFont"));
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource(Resources.getIconName("icon.systemFont.small"))));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "There was an error setting the icon for the editor", e);
        }
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.getContentPane().add((Component)this.getMainPanel());
    }

    protected JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setOpaque(false);
            this.contentPanel.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("left:15dlu"), ColumnSpec.decode("35dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode("8dlu"), FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("35dlu"), FormFactory.UNRELATED_GAP_ROWSPEC}));
            this.contentPanel.add((Component)this.getMessagePanel(), "2, 2, 6, 1, fill, top");
            this.contentPanel.add((Component)this.getUsageLabel(), "2, 4, right, default");
            this.contentPanel.add((Component)this.getUsageValueLabel(), "4, 4, 5, 1");
            this.contentPanel.add((Component)this.getAliasLabel(), "2, 6, right, default");
            this.contentPanel.add((Component)this.getSystemRadio(), "4, 6, 4, 1");
            this.contentPanel.add((Component)this.getSystemComboBox(), "5, 8, 3, 1, left, default");
            this.contentPanel.add((Component)this.getUserRadio(), "4, 10, 4, 1");
            this.contentPanel.add((Component)this.getUserComboBox(), "5, 12, 3, 1, left, default");
            this.contentPanel.add((Component)this.getSizeLabel(), "2, 14, right, default");
            this.contentPanel.add((Component)this.getSizeText(), "4, 14, 2, 1, left, default");
            this.contentPanel.add((Component)this.getSizeLabelHelp(), "7, 14, left, default");
            this.contentPanel.add((Component)this.getStyleLabel(), "2, 16, right, center");
            this.contentPanel.add((Component)this.getPanel(), "4, 16, 4, 1, fill, center");
            this.getButtonGroup();
        }
        return this.contentPanel;
    }

    protected ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.getSystemRadio());
            this.buttonGroup.add(this.getUserRadio());
        }
        return this.buttonGroup;
    }

    public void initialize(PdfFontBean bean, Collection<PdfFontMapping> mappings) {
        if (bean == null) {
            throw new IllegalArgumentException("The font bean can not be null.");
        }
        DefaultComboBoxModel<PdfFontMapping> cBox = new DefaultComboBoxModel<PdfFontMapping>();
        for (PdfFontMapping map : mappings) {
            cBox.addElement(map);
        }
        this.getUserComboBox().setModel(cBox);
        this.getUsageValueLabel().setText(bean.getFontDefinition().toString());
        if (bean.isSystem()) {
            this.getSystemRadio().setSelected(true);
            this.getSystemComboBox().setSelectedItem(bean.getFontFamily());
        } else {
            this.getUserRadio().setSelected(true);
            this.getUserComboBox().setSelectedItem(bean.getFontMapping());
        }
        DecimalFormat df = new DecimalFormat("0.0#");
        this.getSizeText().setText(df.format(bean.getSize()));
        this.getCheckboxBold().setSelected(bean.isBold());
        this.getCheckboxItalic().setSelected(bean.isItalic());
        this.getCheckboxUnderline().setSelected(bean.isUnderline());
        this.fontBean = bean;
    }

    protected boolean isFormValid() {
        boolean valid = true;
        if (this.getSizeText().getText() == null || this.getSizeText().getText().isEmpty()) {
            valid = false;
        }
        if (this.getUserRadio().isSelected() && this.getUserComboBox().getSelectedItem() == null) {
            valid = false;
        }
        if (this.getSystemRadio().isSelected() && this.getSystemComboBox().getSelectedItem() == null) {
            valid = false;
        }
        return valid;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.buttonPanel.getLayout();
            flowLayout.setVgap(10);
            flowLayout.setAlignment(2);
            this.buttonPanel.setOpaque(false);
            this.buttonPanel.setPreferredSize(new Dimension(100, 50));
            this.buttonPanel.add(this.getBtnOk());
            this.buttonPanel.add(this.getBtnCancel());
        }
        return this.buttonPanel;
    }

    protected GradientPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new GradientPanel();
            this.mainPanel.setDirection(0);
            this.mainPanel.setBackground(new Color(248, 248, 255));
            this.mainPanel.setForeground(Color.LIGHT_GRAY);
            this.mainPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.mainPanel.add((Component)this.getContentPanel(), (Object)"Center");
            this.mainPanel.add((Component)this.getButtonPanel(), (Object)"South");
        }
        return this.mainPanel;
    }

    protected JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setPreferredSize(new Dimension(75, 28));
            this.btnOk.setAction(new SaveFontAction());
            this.btnOk.setName("btn-font-ok");
        }
        return this.btnOk;
    }

    protected JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setPreferredSize(new Dimension(75, 28));
            this.btnCancel.setAction(new CancelFontAction());
            this.btnCancel.setName("btn-font-cancel");
        }
        return this.btnCancel;
    }

    protected JLabel getUsageLabel() {
        if (this.usageLabel == null) {
            this.usageLabel = new JLabel(Resources.getString("label.fontUsage"));
        }
        return this.usageLabel;
    }

    protected JLabel getUsageValueLabel() {
        if (this.usageValueLabel == null) {
            this.usageValueLabel = new JLabel("");
            this.usageValueLabel.setName("label-usageValue");
        }
        return this.usageValueLabel;
    }

    protected MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel(UIHelper.convertToMultiline((String)Resources.getString("message.fontEditor.helpText")));
        }
        return this.messagePanel;
    }

    protected JLabel getAliasLabel() {
        if (this.aliasLabel == null) {
            this.aliasLabel = new JLabel(Resources.getString("label.fontAlias"));
        }
        return this.aliasLabel;
    }

    protected JRadioButton getSystemRadio() {
        if (this.systemRadio == null) {
            this.systemRadio = new JRadioButton(Resources.getString("label.fontSystem"));
            this.systemRadio.setOpaque(false);
            this.systemRadio.setSelected(true);
            this.systemRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PdfFontEditor.this.getSystemComboBox().setEnabled(e.getStateChange() == 1);
                }
            });
        }
        return this.systemRadio;
    }

    protected JComboBox getSystemComboBox() {
        if (this.systemComboBox == null) {
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.systemComboBox = new JComboBox<String>(gEnv.getAvailableFontFamilyNames());
            this.systemComboBox.setPreferredSize(new Dimension(250, 24));
            this.systemComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PdfFontEditor.this.getBtnOk().getAction().setEnabled(PdfFontEditor.this.isFormValid());
                }
            });
        }
        return this.systemComboBox;
    }

    protected JRadioButton getUserRadio() {
        if (this.userRadio == null) {
            this.userRadio = new JRadioButton(Resources.getString("label.fontDefined"));
            this.userRadio.setOpaque(false);
            this.userRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PdfFontEditor.this.getUserComboBox().setEnabled(e.getStateChange() == 1);
                }
            });
        }
        return this.userRadio;
    }

    protected JComboBox getUserComboBox() {
        if (this.userComboBox == null) {
            this.userComboBox = new JComboBox();
            this.userComboBox.setPreferredSize(new Dimension(250, 24));
            this.userComboBox.setRenderer(new FontMappingRenderer());
            this.userComboBox.setEnabled(false);
            this.userComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PdfFontEditor.this.getBtnOk().getAction().setEnabled(PdfFontEditor.this.isFormValid());
                }
            });
        }
        return this.userComboBox;
    }

    protected JLabel getSizeLabel() {
        if (this.sizeLabel == null) {
            this.sizeLabel = new JLabel(Resources.getString("label.size"));
        }
        return this.sizeLabel;
    }

    protected JFormattedTextField getSizeText() {
        if (this.sizeText == null) {
            DecimalFormat format = new DecimalFormat("0.0##");
            this.sizeText = new JFormattedTextField(format);
            this.sizeText.setPreferredSize(new Dimension(35, 22));
            this.sizeText.setColumns(8);
            this.sizeText.getDocument().addDocumentListener(new ValidatingDocumentListener());
        }
        return this.sizeText;
    }

    protected JLabel getSizeLabelHelp() {
        if (this.sizeLabelHelp == null) {
            this.sizeLabelHelp = new JLabel(Resources.getString("label.size.unit"));
        }
        return this.sizeLabelHelp;
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
            flowLayout.setAlignment(0);
            this.panel.setOpaque(false);
            this.panel.setPreferredSize(new Dimension(100, 35));
            this.panel.add(this.getCheckboxBold());
            this.panel.add(this.getCheckboxItalic());
            this.panel.add(this.getCheckboxUnderline());
        }
        return this.panel;
    }

    protected JCheckBox getCheckboxBold() {
        if (this.checkboxBold == null) {
            this.checkboxBold = new JCheckBox(Resources.getString("label.font.bold"));
            this.checkboxBold.setName("checkbox-bold");
            this.checkboxBold.setOpaque(false);
        }
        return this.checkboxBold;
    }

    protected JCheckBox getCheckboxItalic() {
        if (this.checkboxItalic == null) {
            this.checkboxItalic = new JCheckBox(Resources.getString("label.font.italic"));
            this.checkboxItalic.setName("checkbox-italic");
            this.checkboxItalic.setOpaque(false);
        }
        return this.checkboxItalic;
    }

    protected JCheckBox getCheckboxUnderline() {
        if (this.checkboxUnderline == null) {
            this.checkboxUnderline = new JCheckBox(Resources.getString("label.font.underline"));
            this.checkboxUnderline.setEnabled(false);
            this.checkboxUnderline.setName("checkbox-underline");
            this.checkboxUnderline.setOpaque(false);
        }
        return this.checkboxUnderline;
    }

    protected JLabel getStyleLabel() {
        if (this.styleLabel == null) {
            this.styleLabel = new JLabel(Resources.getString("label.style"));
        }
        return this.styleLabel;
    }

    private class SaveFontAction
    extends AbstractAction {
        public SaveFontAction() {
            this.putValue("Name", Resources.getString("button.ok"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PdfFontEditor.this.isFormValid()) {
                PdfFontEditor.this.fontBean.setSize(Float.valueOf(PdfFontEditor.this.getSizeText().getText()).floatValue());
                int style = 0;
                if (PdfFontEditor.this.getCheckboxBold().isSelected()) {
                    style |= 1;
                }
                if (PdfFontEditor.this.getCheckboxItalic().isSelected()) {
                    style |= 2;
                }
                if (PdfFontEditor.this.getCheckboxUnderline().isSelected()) {
                    style |= 4;
                }
                PdfFontEditor.this.fontBean.setStyle(style);
                PdfFontEditor.this.fontBean.setSystem(PdfFontEditor.this.getSystemRadio().isSelected());
                if (PdfFontEditor.this.fontBean.isSystem()) {
                    PdfFontEditor.this.fontBean.setFontFamily(PdfFontEditor.this.getSystemComboBox().getSelectedItem().toString());
                } else {
                    PdfFontEditor.this.fontBean.setFontMapping((PdfFontMapping)PdfFontEditor.this.getUserComboBox().getSelectedItem());
                }
            }
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.FontBeanEdit, PdfFontEditor.this.fontBean));
            PdfFontEditor.this.setVisible(false);
        }
    }

    private class CancelFontAction
    extends AbstractAction {
        public CancelFontAction() {
            this.putValue("Name", Resources.getString("button.cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfFontEditor.this.setVisible(false);
        }
    }

    protected class ValidatingDocumentListener
    implements DocumentListener {
        protected ValidatingDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PdfFontEditor.this.getBtnOk().getAction().setEnabled(PdfFontEditor.this.isFormValid());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PdfFontEditor.this.getBtnOk().getAction().setEnabled(PdfFontEditor.this.isFormValid());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PdfFontEditor.this.getBtnOk().getAction().setEnabled(PdfFontEditor.this.isFormValid());
        }
    }

    private class FontMappingRenderer
    extends JLabel
    implements ListCellRenderer {
        private FontMappingRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof PdfFontMapping) {
                PdfFontMapping mapping = (PdfFontMapping)value;
                JLabel label = new JLabel(mapping.getFontAlias());
                return label;
            }
            return null;
        }
    }
}

