/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.CssSelectorNodeFilter;
import org.htmlparser.filters.HasParentFilter;
import org.htmlparser.filters.NotFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.javad.pdf.Page;
import org.javad.stamp.htmlparser.msword.PageProcessor;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;

public class AlbumParser {
    private static final Logger logger = Logger.getLogger(AlbumParser.class.getName());

    public void parse(PageStyle style, String inputFile, String targetFile) {
        try {
            logger.info("Using page style '" + style.toString() + "'");
            long t = System.currentTimeMillis();
            Parser parser = new Parser(inputFile);
            AndFilter pageFilter = new AndFilter((NodeFilter)new CssSelectorNodeFilter(".TableGrid"), (NodeFilter)new NotFilter((NodeFilter)new HasParentFilter((NodeFilter)new TagNameFilter("TD"))));
            StringWriter sw = new StringWriter();
            XMLStreamWriter xtw = this.startXMLDocument(sw);
            SimpleNodeIterator pages = parser.extractAllNodesThatMatch((NodeFilter)pageFilter).elements();
            while (pages.hasMoreNodes()) {
                PageProcessor processor = new PageProcessor(style);
                Node pNode = pages.nextNode();
                Page page = processor.process(pNode, null);
                if (page == null) continue;
                page.writeToXml(xtw);
            }
            this.endXMLDocument(sw, xtw, targetFile);
            logger.info("Completed generation of " + targetFile + " (" + (System.currentTimeMillis() - t) + "ms)");
        }
        catch (XMLStreamException | ParserException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void endXMLDocument(Writer sw, XMLStreamWriter xtw, String targetFile) throws XMLStreamException {
        try {
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), Charset.forName("UTF-8"));
            transformer.transform(new StreamSource(new StringReader(sw.toString())), new StreamResult(out));
        }
        catch (IOException | TransformerException ex) {
            Logger.getLogger(AlbumParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private XMLStreamWriter startXMLDocument(Writer writer) throws XMLStreamException {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter xtw = xof.createXMLStreamWriter(writer);
        xtw.writeStartDocument("utf-8", "1.0");
        xtw.writeDTD("<!DOCTYPE album SYSTEM \"http://www.drakeserver.com/dtds/pagegen.dtd\">");
        xtw.writeStartElement("album");
        return xtw;
    }
}

