/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.htmlparser.Node;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.Span;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.javad.pdf.ISetContent;
import org.javad.pdf.VerticalAlignment;
import org.javad.stamp.htmlparser.HtmlHelper;
import org.javad.stamp.htmlparser.msword.AbstractProcessor;
import org.javad.stamp.htmlparser.msword.ColorMapper;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;
import org.javad.stamp.pdf.IStampContent;
import org.javad.stamp.pdf.StampBox;
import org.javad.stamp.pdf.StampRow;

public class StampRowProcessor
extends AbstractProcessor<ISetContent> {
    private static final Logger logger = Logger.getLogger(StampRowProcessor.class.getName());
    public static int W_PADDING = 4;
    public static int V_PADDING = 5;
    private ColorMapper mapper = ColorMapper.getInstance();
    private int last_height = 0;

    public StampRowProcessor(PageStyle style) {
        super(style);
    }

    @Override
    public ISetContent process(Node stampSet, Node page) {
        StampRow rowSet = new StampRow(this.getPageConfiguration());
        NodeList boxes = this.getNodeListProcessor().findChildrenByTagName(stampSet, "TD");
        for (int i = 0; i < boxes.size(); ++i) {
            Node n = boxes.elementAt(i);
            if (!(n instanceof TagNode)) continue;
            TagNode bNode = (TagNode)n;
            String style = bNode.getAttribute("style");
            String border = HtmlHelper.extractValueFromStyle(style, "border");
            String borderRight = HtmlHelper.extractValueFromStyle(style, "border-right");
            if (border == null && borderRight == null || border != null && border.equals("none") && borderRight != null || borderRight != null && borderRight.equals("none") && border != null) continue;
            StampBox box = new StampBox(this.getPageConfiguration());
            String width = HtmlHelper.extractValueFromStyle(style, "width");
            float f_w = HtmlHelper.convertToNumber(width);
            if (f_w < 0.0f) continue;
            box.setWidth((int)Math.ceil(f_w) - W_PADDING);
            String height = HtmlHelper.extractValueFromStyle(style, "height");
            float f_h = HtmlHelper.convertToNumber(height);
            if (f_h < 0.0f) continue;
            box.setHeight((int)Math.floor(f_h) - V_PADDING);
            if (this.last_height > 0 && box.getHeight() != this.last_height) {
                rowSet.setValign(VerticalAlignment.middle);
            }
            this.last_height = box.getHeight();
            NodeList textList = this.getNodeListProcessor().findChildrenByTagName((Node)bNode, "SPAN");
            if (textList != null && textList.size() > 0) {
                StringBuilder textBuf = new StringBuilder();
                Node parent = null;
                for (int j = 0; j < textList.size(); ++j) {
                    Span span = (Span)textList.elementAt(j);
                    String text = span.getStringText();
                    if (parent != null && span.getParent() != parent) {
                        text = " " + text;
                    }
                    parent = span.getParent();
                    textBuf.append(text);
                }
                if (textBuf.length() > 0) {
                    this.setBoxText(box, textBuf.toString().trim());
                }
            }
            rowSet.addStampContent(box);
        }
        if (rowSet instanceof StampRow && rowSet.getStampContent().isEmpty()) {
            StampRow row = rowSet;
            NodeList childSet = this.getNodeListProcessor().findChildrenByTagName(stampSet, "TABLE");
            if (childSet.size() > 0) {
                try {
                    SimpleNodeIterator iter = childSet.elements();
                    while (iter.hasMoreNodes()) {
                        Node n = iter.nextNode();
                        ISetContent content = this.process(n, page);
                        if (content instanceof StampRow) {
                            StampRow contentRow = (StampRow)content;
                            row.getStampContent().addAll(contentRow.getStampContent());
                            continue;
                        }
                        logger.warning("Something other than a stamp-row is encountered: " + content.getClass().getName());
                    }
                    for (IStampContent c : row.getStampContent()) {
                        if (this.last_height > 0 && c.getHeight() != this.last_height) {
                            row.setValign(VerticalAlignment.middle);
                            break;
                        }
                        this.last_height = c.getHeight();
                    }
                }
                catch (ParserException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return rowSet;
    }

    private void setBoxText(StampBox box, String str) {
        str = str.toLowerCase();
        String text = HtmlHelper.normalizeText(str);
        String[] parts = text.split(" ");
        StringBuilder denom = new StringBuilder();
        StringBuilder desc = new StringBuilder();
        boolean denomination = true;
        for (String part : parts) {
            if (!HtmlHelper.retrieveNumber(part, true).equals("") || (HtmlHelper.startsWithCurrency(part) || part.equals("on") || part.equals("+")) && denomination) {
                if (denom.length() > 0) {
                    denom.append(' ');
                }
                denom.append(part);
                continue;
            }
            denomination = false;
            if (desc.length() > 0) {
                desc.append(' ');
            }
            desc.append(part);
        }
        String denomText = HtmlHelper.normalizeDenomination(denom.toString());
        box.setDenomination(denomText);
        String description = this.mapper.normalizeText(HtmlHelper.normalizeBoxText(desc.toString()));
        box.setDescription(description);
    }
}

