/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword.matchers.legacy;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.htmlparser.Node;
import org.htmlparser.tags.ParagraphTag;
import org.htmlparser.tags.Span;
import org.htmlparser.util.ParserException;
import org.javad.stamp.htmlparser.HtmlHelper;
import org.javad.stamp.htmlparser.msword.NodeListProcessor;
import org.javad.stamp.htmlparser.msword.matchers.NodeMatcher;
import org.javad.stamp.htmlparser.msword.styles.ComponentType;
import org.javad.stamp.htmlparser.msword.styles.LegacyPageStyle;
import org.javad.stamp.htmlparser.msword.styles.MatcherFactory;

public class ClassifierMatcher
extends NodeMatcher {
    private final NodeListProcessor processor = new NodeListProcessor();

    private boolean checkSize(String fontSize) {
        Matcher matcher;
        if (fontSize != null && (matcher = MatcherFactory.NUMBERS.matcher(fontSize.trim())).find()) {
            float size = Float.valueOf(matcher.group(0)).floatValue();
            return size > 8.5f && size < 12.0f;
        }
        return false;
    }

    private boolean checkBottomMargin(Node n) {
        Matcher matcher;
        String marginBottom;
        ParagraphTag pTag;
        String style;
        Node parent = n.getParent();
        if (parent instanceof ParagraphTag && (style = (pTag = (ParagraphTag)parent).getAttribute("style")) != null && (marginBottom = HtmlHelper.extractValueFromStyle(style, "margin-bottom")) != null && (matcher = MatcherFactory.NUMBERS.matcher(marginBottom.trim())).find()) {
            float mb = Float.valueOf(matcher.group(0)).floatValue();
            return mb > 5.09f;
        }
        return false;
    }

    private boolean checkForTitleAsPeer(Node n) {
        Node parent = this.processor.findParentByTagName(n, "P");
        Node sibling = this.processor.findPredecessorSibling(parent);
        if (sibling != null) {
            Node td = this.processor.findParentByTagName(sibling, "TD");
            if (td != null && td.getChildren().indexOf(sibling) > 10) {
                return false;
            }
            try {
                LegacyPageStyle style = new LegacyPageStyle();
                return this.processor.findChildren(sibling.getChildren(), MatcherFactory.getInstance(style).getMatcher(ComponentType.Title)).size() > 0;
            }
            catch (ParserException ex) {
                Logger.getLogger(ClassifierMatcher.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    @Override
    public boolean matches(Node n) {
        Span span;
        String style;
        if (n instanceof Span && (style = (span = (Span)n).getAttribute("style")) != null) {
            String fontSize = HtmlHelper.extractValueFromStyle(style, "font-size");
            return this.checkSize(fontSize) && this.checkBottomMargin(n) && this.checkForTitleAsPeer(n);
        }
        return false;
    }
}

