/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword.matchers.legacy;

import java.util.regex.Matcher;
import org.htmlparser.Node;
import org.htmlparser.tags.ParagraphTag;
import org.htmlparser.tags.Span;
import org.htmlparser.util.NodeList;
import org.javad.stamp.htmlparser.HtmlHelper;
import org.javad.stamp.htmlparser.msword.NodeListProcessor;
import org.javad.stamp.htmlparser.msword.matchers.NodeMatcher;
import org.javad.stamp.htmlparser.msword.matchers.legacy.ClassifierMatcher;
import org.javad.stamp.htmlparser.msword.matchers.legacy.TitleMatcher;
import org.javad.stamp.htmlparser.msword.styles.MatcherFactory;

public class StampSetDescriptionMatcher
extends NodeMatcher {
    private final NodeListProcessor processor = new NodeListProcessor();

    private boolean checkFontSize(Span span) {
        Matcher matcher;
        String fontSize;
        String style = span.getAttribute("style");
        if (style != null && (fontSize = HtmlHelper.extractValueFromStyle(style, "font-size")) != null && (matcher = MatcherFactory.NUMBERS.matcher(fontSize.trim())).find()) {
            float size = Float.valueOf(matcher.group(0)).floatValue();
            return size > 6.5f && size < 9.25f;
        }
        return false;
    }

    private boolean checkBottomMargin(ParagraphTag pTag) {
        Matcher matcher;
        String marginBottom;
        String style = pTag.getAttribute("style");
        if (style != null && (marginBottom = HtmlHelper.extractValueFromStyle(style, "margin-bottom")) != null && (matcher = MatcherFactory.NUMBERS.matcher(marginBottom.trim())).find()) {
            float mb = Float.valueOf(matcher.group(0)).floatValue();
            return mb >= 0.0f && mb < 5.5f;
        }
        return false;
    }

    @Override
    public boolean matches(Node node) {
        ParagraphTag pTag;
        NodeList list;
        if (node instanceof ParagraphTag && (list = this.processor.findChildrenByTagName((Node)(pTag = (ParagraphTag)node), "SPAN")) != null && list.size() > 0) {
            Node first = list.elementAt(0);
            if (new TitleMatcher().matches(first) || new ClassifierMatcher().matches(first)) {
                return false;
            }
            if (this.checkBottomMargin(pTag) && this.checkFontSize((Span)first)) {
                return true;
            }
        }
        return false;
    }
}

