/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.events.StatusEvent;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;
import pub.domain.GradientPanel;

public class AlbumConversionPanel
extends GradientPanel {
    private JFileChooser htmlChooser;
    private JFileChooser dirChooser;
    private String default_folder = null;
    private String default_output_folder = null;
    private static final Logger logger = Logger.getLogger(AlbumConversionPanel.class.getName());
    private JButton buttonDirectory;
    private JButton buttonFile;
    private JButton buttonGenerate;
    private JLabel labelDirectory;
    private JLabel labelFile;
    private JLabel labelMessage;
    private JScrollPane scrollPane;
    private JTextField textDirectory;
    private JTextField textFile;
    private JTextArea textMessage;

    public AlbumConversionPanel() {
        this.setBackground(new Color(248, 248, 255));
        this.setForeground(new Color(211, 211, 211));
        AnnotationProcessor.process((Object)((Object)this));
        this.initComponents();
        Logger.getLogger("org.javad").setLevel(Level.INFO);
        Logger.getLogger("org.javad").addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                AlbumConversionPanel.this.textMessage.append(record.getMessage() + "\n");
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
                AlbumConversionPanel.this.textMessage.setText(null);
            }
        });
        String folder = this.default_output_folder;
        if (this.default_output_folder == null) {
            Preferences prefs = Resources.getPreferencesNode();
            folder = prefs.get("default-xml-output-folder", null);
        }
        if (folder != null) {
            this.textDirectory.setText(folder);
        }
    }

    protected JFileChooser getDirectoryChooser() {
        if (this.dirChooser == null) {
            File f;
            this.dirChooser = new JFileChooser();
            this.dirChooser.setName("pagegen-dirchooser");
            this.dirChooser.setAcceptAllFileFilterUsed(false);
            this.dirChooser.setFileSelectionMode(1);
            this.dirChooser.setFileFilter(new OutputFileFilter());
            String folder = this.default_output_folder;
            if (this.default_output_folder == null) {
                Preferences prefs = Resources.getPreferencesNode();
                folder = prefs.get("default-xml-output-folder", null);
            }
            if (folder != null && (f = new File(folder)).exists() && f.isDirectory()) {
                this.dirChooser.setCurrentDirectory(f);
            }
        }
        return this.dirChooser;
    }

    private JFileChooser getHtmlChooser() {
        if (this.htmlChooser == null) {
            File f;
            this.htmlChooser = new JFileChooser();
            this.htmlChooser.setName("pagegen-htmlChooser");
            this.htmlChooser.setAcceptAllFileFilterUsed(false);
            this.htmlChooser.setFileFilter(new InputFileFilter());
            String folder = this.default_folder;
            if (this.default_folder == null) {
                Preferences prefs = Resources.getPreferencesNode();
                folder = prefs.get("default-html-input-folder", null);
            }
            if (folder != null && (f = new File(folder)).exists()) {
                this.htmlChooser.setCurrentDirectory(f);
            }
        }
        return this.htmlChooser;
    }

    @EventSubscriber(eventClass=PdfAppEvent.class)
    public void handleAppEvent(PdfAppEvent evt) {
        if (evt.getType() == PdfAppEvent.EventType.Generate_Error) {
            if (evt.getData() instanceof IOException) {
                IOException ioe = (IOException)evt.getData();
                String msg = MessageFormat.format(Resources.getString("generate.error.msg"), ioe.getLocalizedMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), msg, Resources.getString("generate.error.title"), 0);
            }
            if (evt.getData() instanceof Throwable) {
                ((Throwable)evt.getData()).printStackTrace();
            }
            logger.log(Level.FINE, "Error generating the pages.", (Throwable)evt.getData());
        }
    }

    private void initComponents() {
        this.labelFile = new JLabel();
        this.textFile = new JTextField();
        this.buttonFile = new JButton();
        this.labelDirectory = new JLabel();
        this.textDirectory = new JTextField();
        this.buttonDirectory = new JButton();
        this.buttonGenerate = new JButton();
        this.scrollPane = new JScrollPane();
        this.textMessage = new JTextArea();
        this.labelMessage = new JLabel();
        this.labelFile.setText("Input File:");
        this.textFile.setEditable(false);
        this.buttonFile.setAction(new ChooseInputFile());
        this.buttonFile.setIcon(new ImageIcon("C:\\dev\\netbeans_projects\\stamp-pagegen\\src\\main\\resources\\images\\html-document-16x16.png"));
        this.labelDirectory.setText("Output Directory:");
        this.textDirectory.setEditable(false);
        this.buttonDirectory.setAction(new ChooseOutputFolder());
        this.buttonDirectory.setIcon(new ImageIcon("C:\\dev\\netbeans_projects\\stamp-pagegen\\src\\main\\resources\\images\\folder-icon-16x16.png"));
        this.buttonGenerate.setAction(new GenerateAction());
        this.buttonGenerate.setText("Generate...");
        this.buttonGenerate.setName("geneateButton");
        this.textMessage.setEditable(false);
        this.textMessage.setColumns(20);
        this.textMessage.setRows(5);
        this.scrollPane.setViewportView(this.textMessage);
        this.labelMessage.setText("Messages:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonGenerate).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelDirectory).addComponent(this.labelFile, -1, -1, Short.MAX_VALUE).addComponent(this.labelMessage, -1, 92, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.textFile).addComponent(this.textDirectory, -1, 243, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonDirectory, -1, -1, Short.MAX_VALUE).addComponent(this.buttonFile, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane, -1, 325, Short.MAX_VALUE).addContainerGap()))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFile).addComponent(this.textFile, -2, -1, -2).addComponent(this.buttonFile)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDirectory).addComponent(this.textDirectory, -2, -1, -2).addComponent(this.buttonDirectory)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonGenerate).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelMessage).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.scrollPane)).addContainerGap()));
    }

    private class InputFileFilter
    extends FileFilter {
        private InputFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && f.canRead() || f.isFile() && f.canRead() && f.getName().toLowerCase().endsWith(".html");
        }

        @Override
        public String getDescription() {
            return Resources.getString("filter.html");
        }
    }

    private class ChooseInputFile
    extends AbstractAction {
        public ChooseInputFile() {
            this.putValue("ShortDescription", Resources.getString("label.inputFile.tooltip"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.fileInput"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            if (0 == AlbumConversionPanel.this.getHtmlChooser().showOpenDialog(AlbumConversionPanel.this.buttonFile) && (f = AlbumConversionPanel.this.getHtmlChooser().getSelectedFile()) != null) {
                if (f.getParent() != null) {
                    Preferences prefs = Resources.getPreferencesNode();
                    prefs.put("default-html-input-folder", f.getParent());
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e1) {
                        logger.log(Level.SEVERE, "Unable to save default folder.", e1);
                    }
                }
                AlbumConversionPanel.this.textFile.setText(f.getAbsolutePath());
                AlbumConversionPanel.this.buttonGenerate.setEnabled(!AlbumConversionPanel.this.textDirectory.getText().isEmpty());
            }
        }
    }

    private class GenerateAction
    extends AbstractAction {
        public GenerateAction() {
            this.putValue("Name", Resources.getString("button.generate"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.generate"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Preferences prefs = Resources.getPreferencesNode();
            prefs.put("default-html-input-file", AlbumConversionPanel.this.textFile.getText());
            EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.ShowBusy, (Object)Resources.getString("message.generating")));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("input", AlbumConversionPanel.this.textFile.getText());
            map.put("output", AlbumConversionPanel.this.textDirectory.getText());
            map.put("pageType", PageStyle.StyleType.Legacy.toString());
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.GenerateXml, map));
        }
    }

    private class ChooseOutputFolder
    extends AbstractAction {
        public ChooseOutputFolder() {
            this.putValue("ShortDescription", Resources.getString("label.outputFolder.tooltip"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.folderOutput"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            if (0 == AlbumConversionPanel.this.getDirectoryChooser().showOpenDialog(AlbumConversionPanel.this.buttonDirectory) && (f = AlbumConversionPanel.this.getDirectoryChooser().getSelectedFile()) != null) {
                Preferences prefs = Resources.getPreferencesNode();
                prefs.put("default-xml-output-folder", f.getPath());
                AlbumConversionPanel.this.default_output_folder = f.getPath();
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e1) {
                    logger.log(Level.SEVERE, "Unable to save default folder.", e1);
                }
                AlbumConversionPanel.this.textDirectory.setText(f.getAbsolutePath());
                AlbumConversionPanel.this.buttonGenerate.setEnabled(!AlbumConversionPanel.this.textFile.getText().isEmpty());
            }
        }
    }

    private class OutputFileFilter
    extends FileFilter {
        private OutputFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && f.canRead();
        }

        @Override
        public String getDescription() {
            return Resources.getString("filter.folder");
        }
    }
}

