/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import org.javad.pdf.VerticalAlignment;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.pdf.IStampContent;
import org.javad.stamp.pdf.StampRow;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.javad.xml.IXMLContentParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StampRowParser
extends AbstractXMLParser<StampRow>
implements XMLDefinitions {
    @Override
    public StampRow parse(Element rowSet, PageConfiguration configuration) {
        NodeList children;
        StampRow row = new StampRow(configuration);
        if (rowSet.hasAttribute("skip")) {
            row.parseSkipTerms(rowSet.getAttribute("skip"));
        }
        if (rowSet.hasAttribute("description")) {
            row.setDescription(rowSet.getAttribute("description").replace("\\n", "\n"));
        }
        if (rowSet.hasAttribute("vertical-offset")) {
            row.setVerticalOffset(Float.parseFloat(rowSet.getAttribute("vertical-offset")));
        }
        if (rowSet.hasAttribute("valign")) {
            row.setValign(VerticalAlignment.valueOf(rowSet.getAttribute("valign")));
        }
        if (rowSet.hasAttribute("spacing-horizontal")) {
            row.setHorizontalPadding(Float.parseFloat(rowSet.getAttribute("spacing-horizontal")));
        }
        if ((children = rowSet.getChildNodes()) != null) {
            for (int j = 0; j < children.getLength(); ++j) {
                IStampContent content;
                Node node = children.item(j);
                if (!(node instanceof Element)) continue;
                Element child = (Element)node;
                IXMLContentParser<?> parser = StampRowParser.getFactory().getParser(child);
                if (parser == null || (content = (IStampContent)parser.parse(child, configuration)) == null) continue;
                row.addStampContent(content);
            }
        }
        return row;
    }
}

